# Water Sort Game Admin Panel - Complete Setup Guide

## 🚀 Quick Start

### Prerequisites
- XAMPP (Apache + MySQL + PHP)
- PHP 8.0 or higher
- Modern web browser

### Step 1: Database Setup
1. Start XAMPP and start Apache & MySQL services
2. Open phpMyAdmin: `http://localhost/phpmyadmin`
3. Create database: `water_sort_admin`
4. Import SQL file: `e:\xamp\htdocs\puzzlegame\admin\database\setup.sql`

### Step 2: Access Admin Panel
1. Open browser: `http://localhost/puzzlegame/admin/auth/login.php`
2. Login with credentials:
   - Username: `admin`
   - Password: `admin123`

### Step 3: Configure Settings
1. Go to Settings → Game Settings
2. Configure game name, rewards, costs
3. Enable/disable ads and IAP as needed

---

## 📁 Complete File Structure

```
admin/
├── setup.php                    # Quick setup wizard
├── auth/
│   ├── login.php                # Login page
│   ├── logout.php               # Logout handler
│   └── session.php              # Session management
├── modules/
│   ├── dashboard.php            # Main dashboard
│   ├── users.php                # User management
│   ├── levels.php               # Level management
│   ├── add-level.php            # Add new level
│   ├── edit-level.php           # Edit existing level
│   ├── analytics.php            # Analytics dashboard
│   ├── reports.php              # Game reports
│   ├── settings.php             # System settings
│   └── activity-logs.php        # Activity logs
├── includes/
│   ├── header.php               # Header template
│   ├── footer.php               # Footer template
│   ├── sidebar.php              # Navigation sidebar
│   └── security.php             # Security functions
├── config/
│   ├── constants.php            # Application constants
│   ├── database.php             # Database connection
│   └── functions.php            # Helper functions
├── assets/
│   ├── css/
│   │   └── admin.css            # Admin panel styles
│   └── js/
│       └── admin.js             # JavaScript functionality
└── database/
    └── setup.sql                 # Database schema
```

---

## 🔐 Security Features

### Authentication
- Secure login with password hashing (ARGON2ID)
- Session timeout protection
- CSRF token protection on all forms
- Login attempt limiting
- Account lockout protection

### Data Protection
- PDO prepared statements everywhere
- Input sanitization and validation
- Output escaping (XSS protection)
- SQL injection prevention
- Secure session management

### Access Control
- Session-based authentication
- Page access protection
- Direct access prevention
- Role-based permissions

---

## 📊 Database Schema

### Tables Created
1. **admins** - Admin user accounts
2. **users** - Game player accounts
3. **levels** - Game levels data
4. **game_plays** - Game session records
5. **activity_logs** - Admin activity tracking
6. **settings** - System configuration

### Key Relationships
- `game_plays.user_id` → `users.id`
- `game_plays.level_id` → `levels.id`
- `activity_logs.admin_id` → `admins.id`

---

## 🎮 Features Overview

### Dashboard
- Real-time statistics
- Recent users display
- Popular levels
- Quick action buttons

### User Management
- View all users with statistics
- Search by username/email
- Delete users with confirmation
- View registration dates
- Track game plays per user

### Level Management
- Create/edit/delete levels
- JSON level data storage
- Difficulty classification
- Play statistics tracking
- Visual level preview

### Analytics
- User registration trends
- Game play analytics
- Revenue tracking
- Performance metrics
- Interactive charts

### Reports
- Detailed game play reports
- Advanced filtering options
- Export functionality
- Pagination support
- Real-time data

### Settings
- Game configuration
- Advertisement settings
- In-app purchase setup
- Security preferences
- System preferences

### Activity Logs
- Complete admin action tracking
- Searchable log history
- IP address logging
- User agent tracking
- Log export/clearing

---

## 🔧 Configuration

### Database Settings (config/constants.php)
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'water_sort_admin');
define('DB_USER', 'root');
define('DB_PASS', '');
```

### Session Settings
```php
define('SESSION_TIMEOUT', 3600); // 1 hour
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOCKOUT_DURATION', 900); // 15 minutes
```

### Security Settings
```php
define('CSRF_TOKEN_LENGTH', 32);
define('PASSWORD_MIN_LENGTH', 8);
define('DEBUG_MODE', false); // Set to false in production
```

---

## 🚨 Troubleshooting

### Common Issues

#### White Screen / Blank Page
1. Check PHP error logs: `C:\xampp\apache\logs\error.log`
2. Enable error reporting: Set `DEBUG_MODE` to `true` in constants.php
3. Check file permissions
4. Verify database connection

#### Database Connection Error
1. Ensure MySQL service is running in XAMPP
2. Check database credentials in constants.php
3. Verify database exists in phpMyAdmin
4. Test connection with setup wizard

#### Login Issues
1. Clear browser cookies
2. Check session timeout settings
3. Verify admin user exists in database
4. Reset admin password if needed

#### CSS Not Loading
1. Check file paths in header.php
2. Verify .htaccess configuration
3. Check browser developer tools for 404 errors
4. Ensure CSS file exists and is readable

### Error Messages

#### "Direct access denied"
- This is normal security protection
- Access pages through proper navigation
- Don't access files directly

#### "Invalid request token"
- CSRF token validation failed
- Refresh the page and try again
- Check session timeout

#### "Database connection failed"
- MySQL service not running
- Wrong database credentials
- Database doesn't exist

---

## 🔄 Maintenance

### Regular Tasks
1. **Backup Database**: Export via phpMyAdmin weekly
2. **Clear Old Logs**: Use activity logs → clear old logs
3. **Update Settings**: Review and update game settings
4. **Monitor Performance**: Check analytics for issues
5. **Security Updates**: Keep PHP and dependencies updated

### Performance Optimization
1. Enable database query caching
2. Optimize large tables with indexes
3. Clean up old activity logs
4. Monitor server resources
5. Use CDN for static assets in production

---

## 📱 Production Deployment

### Security Checklist
- [ ] Set `DEBUG_MODE` to `false`
- [ ] Change default admin password
- [ ] Use HTTPS (SSL certificate)
- [ ] Set secure session cookies
- [ ] Enable firewall rules
- [ ] Regular security audits

### Performance Checklist
- [ ] Enable PHP OPcache
- [ ] Use production database server
- [ ] Optimize database queries
- [ ] Enable gzip compression
- [ ] Use CDN for static assets
- [ ] Monitor server resources

### Backup Strategy
- [ ] Daily automated database backups
- [ ] Off-site backup storage
- [ ] File system backups
- [ ] Disaster recovery plan
- [ ] Test restore procedures

---

## 🆘 Support

### Getting Help
1. Check this guide first
2. Review error logs
3. Test with fresh installation
4. Check XAMPP forums for server issues
5. Search online for specific error messages

### Contact Information
- Game Developer: [Your Contact]
- Technical Support: [Support Email]
- Documentation: [Documentation URL]

---

## 📝 Version History

### v1.0.0 (Current)
- Complete admin panel functionality
- Secure authentication system
- Full CRUD operations
- Analytics and reporting
- Settings management
- Activity logging
- Mobile-responsive design

---

## 🎯 Next Steps

1. **Customize**: Modify colors, logos, and branding
2. **Extend**: Add custom modules and features
3. **Integrate**: Connect with game backend API
4. **Deploy**: Move to production server
5. **Monitor**: Set up monitoring and alerts

---

**🎉 Congratulations! Your Water Sort Game Admin Panel is now ready for use!**

For any issues or questions, refer to this guide or check the error logs for detailed information.
