<?php
// Define admin access for security
define('ADMIN_ACCESS', true);

// Include required files
require_once __DIR__ . '/../config/constants.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/functions.php';
require_once __DIR__ . '/../includes/security.php';

// Handle logout
if (Auth::isLoggedIn()) {
    // Log the logout activity
    logActivity('admin_logout', 'admins', $_SESSION['admin_id'], null, 'Admin logged out');
    
    // Destroy session
    Auth::logout();
}

// Clear remember me cookie if exists
if (isset($_COOKIE['admin_remember'])) {
    setcookie('admin_remember', '', time() - 3600, '/');
    unset($_COOKIE['admin_remember']);
}

// Redirect to login page with logout message
header('Location: ' . ADMIN_URL . '/auth/login.php?logout=1');
exit;
?>
