<?php
// Define admin access for security
define('ADMIN_ACCESS', true);

// Include required files
require_once __DIR__ . '/../config/constants.php';
require_once __DIR__ . '/../config/database.php';
require_once __DIR__ . '/../config/functions.php';
require_once __DIR__ . '/../includes/security.php';

// Set JSON response header
header('Content-Type: application/json');

// Handle session actions
$action = $_GET['action'] ?? '';
$response = ['success' => false, 'message' => 'Invalid action'];

switch ($action) {
    case 'extend':
        // Extend session timeout
        if (Auth::isLoggedIn()) {
            $_SESSION['last_activity'] = time();
            $response = [
                'success' => true,
                'message' => 'Session extended',
                'new_timeout' => time() + SESSION_TIMEOUT
            ];
            
            // Log session extension
            logActivity('session_extend', $_SESSION['admin_id'], 'Admin session extended');
        } else {
            $response['message'] = 'Not logged in';
        }
        break;
        
    case 'check':
        // Check session status
        if (Auth::isLoggedIn()) {
            $last_activity = $_SESSION['last_activity'] ?? 0;
            $time_remaining = SESSION_TIMEOUT - (time() - $last_activity);
            
            $response = [
                'success' => true,
                'logged_in' => true,
                'time_remaining' => max(0, $time_remaining),
                'username' => $_SESSION['admin_username']
            ];
        } else {
            $response = [
                'success' => true,
                'logged_in' => false,
                'message' => 'Not logged in'
            ];
        }
        break;
        
    case 'refresh':
        // Refresh session data
        if (Auth::isLoggedIn()) {
            // Update last activity
            $_SESSION['last_activity'] = time();
            
            // Get fresh admin data from database
            try {
                $db = Database::getInstance();
                $stmt = $db->prepare("SELECT * FROM admins WHERE id = ?");
                $stmt->execute([$_SESSION['admin_id']]);
                $admin = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($admin) {
                    // Update session with fresh data
                    $_SESSION['admin_username'] = $admin['username'];
                    $_SESSION['admin_email'] = $admin['email'];
                    $_SESSION['admin_role'] = $admin['role'];
                    
                    $response = [
                        'success' => true,
                        'message' => 'Session refreshed',
                        'admin_data' => [
                            'username' => $admin['username'],
                            'email' => $admin['email'],
                            'role' => $admin['role'],
                            'last_login' => $admin['last_login']
                        ]
                    ];
                } else {
                    $response['message'] = 'Admin user not found';
                }
            } catch (Exception $e) {
                $response['message'] = 'Database error: ' . $e->getMessage();
            }
        } else {
            $response['message'] = 'Not logged in';
        }
        break;
        
    default:
        $response['message'] = 'Unknown action';
        break;
}

// Send JSON response
echo json_encode($response);
?>
