<?php
/**
 * Application Constants
 * Water Sort Game Admin Panel
 */

// Application constants
define('APP_NAME', 'Water Sort Game Admin');
define('APP_VERSION', '1.0.0');
define('APP_URL', 'http://localhost/puzzlegame/admin/');
define('ADMIN_URL', 'http://localhost/puzzlegame/admin');
define('ADMIN_PATH', __DIR__ . '/..');

// Database constants
define('DB_HOST', 'localhost');
define('DB_NAME', 'water_sort_admin');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Session constants
define('SESSION_LIFETIME', 3600); // 1 hour
define('SESSION_TIMEOUT', 3600); // 1 hour (for compatibility)
define('SESSION_NAME', 'water_sort_admin');
define('COOKIE_SECURE', false); // Set to true if using HTTPS
define('COOKIE_HTTPONLY', true);

// Security constants
define('MAX_LOGIN_ATTEMPTS', 5);
define('LOCKOUT_DURATION', 900); // 15 minutes
define('CSRF_TOKEN_LENGTH', 32);
define('PASSWORD_MIN_LENGTH', 8);

// Pagination constants
define('ITEMS_PER_PAGE', 20);
define('MAX_ITEMS_PER_PAGE', 100);

// File upload constants
define('MAX_FILE_SIZE', 5242880); // 5MB
define('ALLOWED_FILE_TYPES', ['jpg', 'jpeg', 'png', 'gif']);

// Email constants (if needed later)
define('ADMIN_EMAIL', 'admin@watersort.game');
define('FROM_EMAIL', 'noreply@watersort.game');

// Debug mode (set to false in production)
define('DEBUG_MODE', true);
define('DISPLAY_ERRORS', DEBUG_MODE);

// Error reporting
if (DEBUG_MODE) {
    error_reporting(E_ALL);
    ini_set('display_errors', 1);
} else {
    error_reporting(0);
    ini_set('display_errors', 0);
}

// Timezone
date_default_timezone_set('UTC');

// Security headers
if (!headers_sent()) {
    header('X-Content-Type-Options: nosniff');
    header('X-Frame-Options: DENY');
    header('X-XSS-Protection: 1; mode=block');
    header('Referrer-Policy: strict-origin-when-cross-origin');
}
?>
