<?php
// Prevent direct access
if (!defined('ADMIN_ACCESS')) {
    header('HTTP/1.0 403 Forbidden');
    exit('Direct access not permitted');
}
?>
            </main>
        </div>
        
        <!-- Footer -->
        <footer class="admin-footer">
            <div class="footer-content">
                <div class="footer-left">
                    <p>&copy; <?php echo date('Y'); ?> Water Sort Game Admin Panel</p>
                    <p>Version 1.0.0</p>
                </div>
                
                <div class="footer-right">
                    <p>
                        <span class="footer-link">
                            <a href="#">Documentation</a>
                        </span>
                        <span class="footer-link">
                            <a href="#">Support</a>
                        </span>
                        <span class="footer-link">
                            <a href="#">API</a>
                        </span>
                    </p>
                </div>
            </div>
        </footer>
    </div>
    
    <!-- JavaScript -->
    <script src="<?php echo ADMIN_URL; ?>/assets/js/admin.js"></script>
    
    <!-- Debug Mode Notice -->
    <?php if (DEBUG_MODE): ?>
    <div class="debug-notice">
        <p>⚠️ Debug mode is enabled</p>
    </div>
    <?php endif; ?>
    
    <!-- Session Timeout Warning -->
    <script>
        // Session timeout warning
        let sessionTimeout = <?php echo SESSION_TIMEOUT; ?> * 1000; // Convert to milliseconds
        let warningTime = 5 * 60 * 1000; // 5 minutes before timeout
        let warningShown = false;
        
        function checkSessionTimeout() {
            let lastActivity = <?php echo time(); ?>;
            let currentTime = new Date().getTime() / 1000;
            let timeSinceActivity = (currentTime - lastActivity) * 1000;
            
            if (timeSinceActivity >= sessionTimeout - warningTime && !warningShown) {
                showSessionWarning();
                warningShown = true;
            }
            
            if (timeSinceActivity >= sessionTimeout) {
                window.location.href = '<?php echo ADMIN_URL; ?>/auth/logout.php?timeout=1';
            }
        }
        
        function showSessionWarning() {
            if (confirm('Your session will expire in 5 minutes. Do you want to extend it?')) {
                // Extend session by making an AJAX request
                fetch('<?php echo ADMIN_URL; ?>/auth/session.php?action=extend')
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            warningShown = false;
                            showNotification('Session extended successfully', 'success');
                        }
                    })
                    .catch(error => {
                        console.error('Error extending session:', error);
                    });
            }
        }
        
        // Check session timeout every minute
        setInterval(checkSessionTimeout, 60000);
        
        // Show notification function
        function showNotification(message, type = 'info') {
            const notification = document.createElement('div');
            notification.className = `notification ${type}`;
            notification.textContent = message;
            
            document.body.appendChild(notification);
            
            // Auto remove after 3 seconds
            setTimeout(() => {
                notification.remove();
            }, 3000);
        }
        
        // Auto-hide notifications
        document.addEventListener('DOMContentLoaded', function() {
            const notifications = document.querySelectorAll('.notification');
            notifications.forEach(notification => {
                setTimeout(() => {
                    notification.style.opacity = '0';
                    setTimeout(() => {
                        notification.remove();
                    }, 300);
                }, 3000);
            });
        });
    </script>
</body>
</html>
