<?php
// Define admin access for security
define('ADMIN_ACCESS', true);

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Login Test</h1>";

try {
    // Include required files
    require_once __DIR__ . '/config/constants.php';
    echo "✅ Constants loaded<br>";
    
    require_once __DIR__ . '/config/functions.php';
    echo "✅ Functions loaded<br>";
    
    require_once __DIR__ . '/config/database.php';
    echo "✅ Database loaded<br>";
    
    require_once __DIR__ . '/includes/security.php';
    echo "✅ Security loaded<br>";
    
    // Test constants
    echo "<br>Constants test:<br>";
    echo "ADMIN_URL: " . ADMIN_URL . "<br>";
    echo "SESSION_TIMEOUT: " . SESSION_TIMEOUT . "<br>";
    
    // Test functions
    echo "<br>Functions test:<br>";
    if (function_exists('generateCSRFToken')) {
        $token = generateCSRFToken();
        echo "✅ CSRF token generated: " . substr($token, 0, 10) . "...<br>";
    }
    
    // Test classes
    echo "<br>Classes test:<br>";
    if (class_exists('Auth')) {
        echo "✅ Auth class exists<br>";
        if (method_exists('Auth', 'isLoggedIn')) {
            echo "✅ Auth::isLoggedIn method exists<br>";
            $loggedIn = Auth::isLoggedIn();
            echo "Logged in status: " . ($loggedIn ? 'Yes' : 'No') . "<br>";
        }
    }
    
    if (class_exists('SessionManager')) {
        echo "✅ SessionManager class exists<br>";
    }
    
    echo "<br>✅ All tests passed! Try the <a href='auth/login.php'>login page</a> now.";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
    echo "Stack trace:<br><pre>" . $e->getTraceAsString() . "</pre>";
} catch (Error $e) {
    echo "❌ Fatal Error: " . $e->getMessage() . "<br>";
    echo "Stack trace:<br><pre>" . $e->getTraceAsString() . "</pre>";
}
?>
