<?php
// Define admin access for security
define('ADMIN_ACCESS', true);

// Test basic includes
echo "Testing includes...<br>";

try {
    require_once __DIR__ . '/config/constants.php';
    echo "✅ Constants loaded<br>";
} catch (Exception $e) {
    echo "❌ Constants error: " . $e->getMessage() . "<br>";
}

try {
    require_once __DIR__ . '/config/functions.php';
    echo "✅ Functions loaded<br>";
} catch (Exception $e) {
    echo "❌ Functions error: " . $e->getMessage() . "<br>";
}

// Test without database first
echo "<br>Testing without database...<br>";
echo "ADMIN_URL: " . (defined('ADMIN_URL') ? ADMIN_URL : 'NOT DEFINED') . "<br>";

// Test CSRF token
if (function_exists('generateCSRFToken')) {
    echo "✅ CSRF token function exists<br>";
    $token = generateCSRFToken();
    echo "Token: " . substr($token, 0, 10) . "...<br>";
} else {
    echo "❌ CSRF token function missing<br>";
}

echo "<br>Basic test complete!";
?>
